# Try to find the OGG library
#  OGG_FOUND - system has OGG
#  OGG_INCLUDE_DIR - the OGG include directory
#  OGG_LIBRARY - the OGG library

FIND_PATH(OGG_INCLUDE_DIR NAMES ogg/ogg.h)
SET(_OGG_STATIC_LIBS libogg.a)
SET(_OGG_SHARED_LIBS libogg.dll.a ogg)
IF(USE_STATIC_LIBS)
    FIND_LIBRARY(OGG_LIBRARY NAMES ${_OGG_STATIC_LIBS} ${_OGG_SHARED_LIBS})
ELSE()
    FIND_LIBRARY(OGG_LIBRARY NAMES ${_OGG_SHARED_LIBS} ${_OGG_STATIC_LIBS})
ENDIF()
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Ogg DEFAULT_MSG OGG_LIBRARY OGG_INCLUDE_DIR)
MARK_AS_ADVANCED(OGG_LIBRARY OGG_INCLUDE_DIR)
